package com.hero.objects.talents;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class LightningReflexesSingle extends Talent {

	public static String xmlID = "LIGHTNING_REFLEXES_SINGLE";

	public LightningReflexesSingle(Element root) {
		super(root, LightningReflexesSingle.xmlID);
		setInput("Single Action");
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();
		if ((getName() != null) && (getName().trim().length() > 0)) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public void setInput(String val) {
		super.setInput(val);
		if (getDisplay().indexOf("Single Action") > 0) {
			String part1 = getDisplay().substring(0,
					getDisplay().indexOf("Single Action"));
			String part2 = getDisplay().indexOf("SingleAction" + 13) < getDisplay()
					.length() ? getDisplay().substring(
					getDisplay().indexOf("Single Action") + 13,
					getDisplay().length()) : "";
			setAlias(part1 + "+" + getLevels() + " DEX to act first with "
					+ val + part2);
		}
	}

	@Override
	public void setLevels(int val) {
		if (getAlias().indexOf("+" + getLevels()) > 0) {
			String part1 = getAlias().substring(0,
					getAlias().indexOf("+" + getLevels()));
			String part2 = getAlias().indexOf("+" + getLevels())
					+ (getLevels() < 10 ? 2 : 3) < getAlias().length() ? getAlias()
					.substring(
							getAlias().indexOf("+" + getLevels())
									+ (getLevels() < 10 ? 2 : 3),
							getAlias().length())
					: "";
			super.setLevels(val);
			setAlias(part1 + "+" + getLevels() + part2);
		} else {
			super.setLevels(val);
		}
	}
}